
module File =

(* returns the contents of a file as a string
   if an error occurs, returns an empty string *)
let readfile filename = 
  let filesize = 
    case Posix.stat filename 
     | Posix.Result st -> st.Posix.st_size
     | Posix.PosixError _ -> 0
    end in 
    
  let fd = Posix.open filename [| Posix.O_RDONLY |] in 

  let rec readfiletostringbuf fd s pos numberofbytestoread = 
    numberofbytestoread = 0 || (* the recursion ends when there is nothing more to read *)
     let len = Posix.read fd s (min numberofbytestoread 0xffff) pos in 
     len > 0 && (* len <= 0 indicates we have reached the end of the file before expected, which is an error *)
     readfiletostringbuf fd s (pos + len) (numberofbytestoread - len)
   in 
   
  let databuf = String.build filesize in  
  let res = readfiletostringbuf fd databuf 0 filesize in 
  
  if res then 
    databuf
  else
    ""

endmodule
